function [] = find_centroid_multi(varargin)
%This is a high order script that allows you to run find_centroidvstk
%Synatax:   [] = find_centroid_multi('dirname',array,'theshold',0.5,'type',2,'type2',1,'norm',1)
%Input:     'dirname' = directory where the images are
%           'threshold' = if left off no threshold will be given, if given
%               the value should be between [0 1], and only maxima above
%               the desired level will be counted. Now by Default threshold
%               is 10% or 0.1 for localmax, centroids = 0.1 or 10%.  Now
%               the function will allow you to iterate through a number of
%               threshold you enter, essentially in the format:
%               (0.1,0.05...)
%           type = 1(centroid), 2 (WeightedCentroid) or 0(local max), 
%               default = 0(local max)
%           type2 = 1(Area), 2(Max Intensity), 3(Min Intensity, 4(Pixel #)
%                   default = 0(Mean Intensity) Note: only works with
%                   centroids
%           norm = normalize the images, essentially stretching the image
%                   data over the full bit range.  Only works in centroid
%                   mode.  Default = 1, or on, and will not affect the
%                   intensity  measurements, now matches threshold.
%           object = out put the images of the objects.  Default = 0(off)
%               Does not work with local max
%           zfilter = requires the objects to be in more than 1 z slice
%           Note: as this is setup currently, if there is a directory with
%           images that also contain directories, those images will not be
%           processed.  Images are only processed in end directories.
%Output:    none

[threshold,dirname,type,type2,norm,object,zfilter] = parse(varargin);

%now grab those directory names
dir_struct = dir(dirname);  %grab the directory information
idx = [dir_struct.isdir];   %grab all of the isdir numbers
idx(1:2) = 0;               %remove the first two directories
dirnames = {dir_struct.name};   %grab the all of the names in the root
dirnames = dirnames(idx);  %don't want the first two
dir_tmp = repmat([dirname filesep],size(dirnames'));    %replicated the directory name for appending

%prepare the output directory
warning('OFF','MATLAB:MKDIR:DirectoryExists');  %turn off this specific warning
sep_loc = strfind(dirname,filesep);
out_tmp = [dirname(1:sep_loc(end)),'CalculatedCentroids',dirname(sep_loc(end):end)];
mkdir(dirname(1:sep_loc(end)),'CalculatedCentroids')  %make the output root directories
mkdir([dirname(1:sep_loc(end)),'CalculatedCentroids'],dirname(sep_loc(end)+1:end));
out_tmp = repmat([out_tmp filesep],size(dirnames'));    %replicated the out_put name for appending
out_list = horzcat(cellstr(out_tmp),dirnames');      %now each cell contains the full output directory path
category = 'manuel';  %the threshold is set hard in this one.

dirnames = cellstr([dir_tmp char(dirnames')]);      %now each cell contains the full directory path

if ~isempty(dirnames)   %if the root only have files, then no need to go further
    while 1     %we are going to dig until all sub_dirs are found
        dir_tmp = [];   %clear!
        dir_end = 0;    %reset
        out_tmp = [];
        %level in
        for i = 1:size(dirnames,1)  %for each dir_step down one
            warning('OFF','MATLAB:MKDIR:DirectoryExists');  %turn off this specific warning
            mkdir(out_list{i,1},out_list{i,2});     %copy over this directory
            curr_out = [out_list{i,1} out_list{i,2}];     %current output directory
            curr_dir = dirnames{i};     %current directory
            dir_info = dir(curr_dir); %grab the current dir
            idx = [dir_info.isdir];   %grab all of the isdir numbers
            idx(1:2) = 0;   %toss the first two
            curr_names = {dir_info.name};   %grab the all of the 
            dir_nxt = curr_names(idx);    %the directories
            if isempty(dir_nxt)   %bottom
                dir_end = dir_end+1;    %one path to its conclusion
                %now lets see if this directory have the image files we
                %are looking for
                idx = [dir_info.isdir];   %grab all of the isdir numbers
                filenames = curr_names(~idx);   %files
                tifsrc = strfind(filenames,'.tif');     %serch for tif files
                if size(cell2mat(tifsrc),2)>=2    %if there are at least two images
                    disp(curr_out);  %print current directory to command line
                    %first parse the directory structure
                    dir_idx = find(curr_dir==filesep);  %where are all of slashes
                    ch_name = curr_dir(dir_idx(end)+1:end);     %grab the channel protein name, e.g., PSD95
                    reg_name = curr_dir(dir_idx(end-1)+1:dir_idx(end)-1);   %the tissue region, e.g., Layer5
                    ani_name = curr_dir(dir_idx(end-2)+1:dir_idx(end-1)-1); %the animal type, e.g, KO, WT, Wake, etc...
                    exp_name = curr_dir(dir_idx(end-3)+1:dir_idx(end-2)-1); %the experiment name, e.g., 20140211
                    %parse the ch_name further for consumption
                    spc_loc = isspace(ch_name);  %get the space locations for the name string
                    if sum(spc_loc)==2  %we want the specific formate '1 PSD95 594'
                        str_idx = find(spc_loc==1);  
                        ch_name = ch_name(str_idx(1)+1:str_idx(2)-1);
                    end
                    %otherwise the ch_name is not modified
                    %run find_centroidvstk
                    pivots_tmp = find_centroidvstk('dirname',curr_dir,'type',type,'type2',type2,'object',object,'threshold',threshold,'norm',norm,...
                        'zfilter',zfilter,'dirout',out_list{i,1});
                    %now lets store the centroids data for later retrieval
                    %now generate output data structure
                    if ~isempty(centroid_data)
                        ani_fields = fields(centroid_data);
                        if max(strcmpi(ani_fields,ani_name))
                            reg_fields = fields(centroid_data.(ani_name));
                        end
                    end
                    if isempty(centroid_data)||~max(strcmpi(ani_fields,ani_name))||~max(strcmpi(reg_fields,reg_name))  %initiate if this is the first point
                        centroid_data.(ani_name).(reg_name).centroid = {[],ch_name;exp_name,size(pivots_tmp{1},1)};        %centroid number
                        centroid_data.(ani_name).(reg_name).threshold = {[],ch_name;exp_name,threshold};                   %threshold used
                        centroid_data.(ani_name).(reg_name).category = {[],ch_name;exp_name,category};                   %threshold method
                        centroid_data.(ani_name).(reg_name).location = {[],ch_name;exp_name,{curr_dir,out_list{i,1}}};     %location of files
                    else  %if not the first time lets first find where to place it
                        [x,y] = locate_xy(centroid_data.(ani_name).(reg_name).centroid,ch_name,exp_name);  %where should we put the data
                        %put in the labels
                        centroid_data.(ani_name).(reg_name).centroid{y,1} = exp_name;        %centroid number
                        centroid_data.(ani_name).(reg_name).threshold{y,1} = exp_name;                   %threshold used
                        centroid_data.(ani_name).(reg_name).category{y,1} = exp_name;                   %threshold method
                        centroid_data.(ani_name).(reg_name).location{y,1} = exp_name;     %location of files
                        centroid_data.(ani_name).(reg_name).centroid{1,x} = ch_name;        %centroid number
                        centroid_data.(ani_name).(reg_name).threshold{1,x} = ch_name;                   %threshold used
                        centroid_data.(ani_name).(reg_name).category{1,x} = ch_name;                   %threshold method
                        centroid_data.(ani_name).(reg_name).location{1,x} = ch_name;     %location of files
                        %put the data in
                        centroid_data.(ani_name).(reg_name).centroid{y,x} = size(pivots_tmp{1},1);        %centroid number
                        centroid_data.(ani_name).(reg_name).threshold{y,x} = threshold;                   %threshold used
                        centroid_data.(ani_name).(reg_name).category{y,x} = category;                   %threshold method
                        centroid_data.(ani_name).(reg_name).location{y,x} = {curr_dir,out_list{i,1}};     %location of files
                    end                    
                end
            else    %not the bottom
                curr_dir = repmat([curr_dir filesep],size(dir_nxt'));    %replicated the directory name for appending
                dir_tmp = vertcat(dir_tmp,cellstr([curr_dir char(dir_nxt')]));      %now each cell contains the full directory path
                curr_out = repmat([curr_out filesep],size(dir_nxt'));    %replicated the out_put name for appending
                out_tmp = vertcat(out_tmp,horzcat(cellstr(curr_out),dir_nxt'));      %now each cell contains the full output directory path
            end
        end
        if dir_end==size(dirnames,1)    %all directories are at an end
            break
        else    %move next level down
            dirnames = dir_tmp;
            out_list = out_tmp;
        end
    end
    %done save out the data
    centroid_data.norm = norm;  %save out some parameters as well
    centroid_data.object = object;
    centroid_data.zfilter = zfilter;
    centroid_data.type = type;
    centroid_data.type2 = type2;
    %now save it
    save([dirname,filesep,'centroid_data',datestr(now,'yyyymmdd.HHMM'),'.mat'],'centroid_data');
end

%--------------------------------------------------------------------------
%subfunction to parse the inputs.
function [threshold,dirname,type,type2,norm,object,zfilter] = parse(input)

threshold = [];    
type = 0;
type2 = 0;      %default is 0; now you can define the accessory data, acquired instead of Luminance
norm = 1;
object = 0;
dirname = [];
zfilter = 0;

%Parse the input
if ~isempty(input)
    for i = 1:2:size(input,2)
        if ischar(input{1,i});
            switch input{1,i}
                case 'dirname'
                    dirname = input{1,i+1};
                case 'threshold'
                    threshold = input{1,i+1};
                case 'type'
                    type = input{1,i+1};
                case 'type2'
                    type2 = input{1,i+1};
                case 'norm'
                    norm = input{1,i+1};
                case 'object'
                    object = input{1,i+1};
                case 'zfilter'
                    zfilter = input{1,i+1};
                otherwise
                    warning(['Your input ',input{1,i},' is not recognized.']);
            end
        else
            error(['The parameters you entered is incorrect.  Please check help.']);
        end
    end
end

%Get the location of the images you want to open
if isempty(dirname)
    dirname = uigetdir2('','Directory where your images are');    %get the directory
end
%set threshold, if the user have not already.
if isempty(threshold)
    switch type
        case 0   %default local max
            threshold = 0.1;
        otherwise  %centroid or weighted centroid
            threshold = 0.1;
    end
end